//
// $Id: fmsound.h,v 1.9 2001/07/13 16:14:09 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//





#if BX_USE_FMSND_SMF
#  define BX_FMSOUND_SMF  static
#  define BX_FMSOUND_THIS bx_fmsound.
#else
#  define BX_FMSOUND_SMF
#  define BX_FMSOUND_THIS this->
#endif

class bx_fmsound_c : public logfunctions {
public:
  bx_fmsound_c(void);
  ~bx_fmsound_c(void);

  BX_FMSOUND_SMF void init(bx_devices_c *);
  static void ym2612_irq_handler(int irq);
  static void fm_pcm_interrupt(int bank);
  BX_FMSOUND_SMF void update_irq(void);
  BX_FMSOUND_SMF Bit8u  mem_read(Bit32u addr);
  // Note: either leave value of type Bit8u, or mask it when
  //       used to 8 bits, in memory.cc
  BX_FMSOUND_SMF void   mem_write(Bit32u addr, Bit8u value);

private:
  bx_devices_c *devices;

  Boolean ym2612_irq;
  Boolean irq13_raising;
  Bit8u pcm_int_mask,pcm_int_flag;

  static Bit32u read_handler(void *this_ptr, Bit32u address, unsigned io_len);
  static void   write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len);
#if !BX_USE_FMSND_SMF
  Bit32u read(Bit32u address, unsigned io_len);
  void   write(Bit32u address, Bit32u value, unsigned len);
#endif
  };


extern bx_fmsound_c bx_fmsound;
